/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.event;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.items.ItemMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class InventoryChangedEvent
extends EntityEvent {
    public static HashSet<Class<? extends Entity>> watchedClasses = new HashSet();
    public static HashMap<Entity, GlobalInventoryData> previousContents = new LinkedHashMap<Entity, GlobalInventoryData>();
    public final GlobalInventoryData oldInventory;
    public final GlobalInventoryData newInventory;

    public InventoryChangedEvent(Entity entity, GlobalInventoryData oldInventory, GlobalInventoryData newInventory) {
        super(entity);
        this.oldInventory = oldInventory;
        this.newInventory = newInventory;
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.CLIENT || event.phase == TickEvent.Phase.START || watchedClasses.size() == 0) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Profiler profiler = server.field_71304_b;
        profiler.func_76320_a("Fantastic Lib: InventoryChangedEvent");
        LinkedHashMap<Entity, GlobalInventoryData> newContents = new LinkedHashMap<Entity, GlobalInventoryData>();
        ArrayList<InventoryChangedEvent> events = new ArrayList<InventoryChangedEvent>();
        for (WorldServer world : MCTools.DIMENSION_MANAGER_WORLDS.values()) {
            for (Entity entity : world.field_72996_f.toArray(new Entity[0])) {
                if (entity.field_70128_L) continue;
                boolean found = false;
                for (Class<? extends Entity> cls : watchedClasses) {
                    if (!cls.isAssignableFrom(entity.getClass())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                GlobalInventoryData oldInventory = previousContents.get(entity);
                GlobalInventoryData newInventory = new GlobalInventoryData(entity);
                if (oldInventory != null && oldInventory.equals(newInventory)) {
                    newContents.put(entity, oldInventory);
                    continue;
                }
                events.add(new InventoryChangedEvent(entity, oldInventory, newInventory));
                newContents.put(entity, newInventory.deepCopy());
            }
        }
        profiler.func_76318_c("Fantastic Lib: InventoryChangedEvent listeners");
        for (InventoryChangedEvent event1 : events) {
            MinecraftForge.EVENT_BUS.post((Event)event1);
        }
        profiler.func_76318_c("Fantastic Lib: InventoryChangedEvent map replacement");
        previousContents = newContents;
        profiler.func_76319_b();
    }

    static {
        MinecraftForge.EVENT_BUS.register(InventoryChangedEvent.class);
    }

    public static class GlobalInventoryData
    implements INBTSerializable<NBTTagCompound> {
        public final ItemStack[] allNonSkin;
        public final ItemStack[] tiamatInventory;

        public GlobalInventoryData(Entity entity) {
            this.allNonSkin = GlobalInventory.getAllNonSkinItems(entity).toArray(new ItemStack[0]);
            this.tiamatInventory = GlobalInventory.getAllTiamatItems(entity).toArray(new ItemStack[0]);
        }

        public GlobalInventoryData deepCopy() {
            int i = 0;
            for (ItemStack stack : this.allNonSkin) {
                this.allNonSkin[i++] = stack.func_77946_l();
            }
            i = 0;
            for (ItemStack stack : this.tiamatInventory) {
                this.tiamatInventory[i++] = stack.func_77946_l();
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof GlobalInventoryData)) {
                return false;
            }
            GlobalInventoryData other = (GlobalInventoryData)obj;
            if (this.allNonSkin.length != other.allNonSkin.length) {
                return false;
            }
            return ItemMatcher.stacksMatch(this.allNonSkin, other.allNonSkin);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            return null;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
        }
    }
}

